/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.architectury.registry.registries.Registries;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.FluidConfig;
import dev.ftb.mods.ftblibrary.config.NBTConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class FluidTask
extends Task {
    public static final ResourceLocation TANK_TEXTURE = new ResourceLocation("ftbquests", "textures/tasks/tank.png");
    public Fluid fluid = Fluids.f_76193_;
    public CompoundTag fluidNBT = null;
    public long amount = FluidStack.bucketAmount();
    private FluidStack cachedFluidStack = null;

    public FluidTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.FLUID;
    }

    @Override
    public long getMaxProgress() {
        return this.amount;
    }

    @Override
    public String formatMaxProgress() {
        return FluidTask.getVolumeString(this.amount);
    }

    @Override
    public String formatProgress(TeamData teamData, long progress) {
        return FluidTask.getVolumeString((int)Math.min(Integer.MAX_VALUE, progress));
    }

    @Override
    public boolean consumesResources() {
        return true;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("fluid", Registries.getId((Object)this.fluid, (ResourceKey)Registry.f_122899_).toString());
        nbt.m_128356_("amount", this.amount);
        if (this.fluidNBT != null) {
            nbt.m_128365_("nbt", (Tag)this.fluidNBT);
        }
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.fluid = (Fluid)Registry.f_122822_.m_7745_(new ResourceLocation(nbt.m_128461_("fluid")));
        if (this.fluid == null || this.fluid == Fluids.f_76191_) {
            this.fluid = Fluids.f_76193_;
        }
        this.amount = Math.max(1L, nbt.m_128454_("amount"));
        this.fluidNBT = (CompoundTag)nbt.m_128423_("nbt");
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130085_(Registries.getId((Object)this.fluid, (ResourceKey)Registry.f_122899_));
        buffer.m_130079_(this.fluidNBT);
        buffer.m_130103_(this.amount);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.fluid = (Fluid)Registry.f_122822_.m_7745_(buffer.m_130281_());
        if (this.fluid == null || this.fluid == Fluids.f_76191_) {
            this.fluid = Fluids.f_76193_;
        }
        this.fluidNBT = buffer.m_130260_();
        this.amount = buffer.m_130258_();
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        this.cachedFluidStack = null;
    }

    public FluidStack createFluidStack() {
        if (this.cachedFluidStack == null) {
            this.cachedFluidStack = FluidStack.create((Fluid)this.fluid, (long)FluidStack.bucketAmount(), (CompoundTag)this.fluidNBT);
        }
        return this.cachedFluidStack;
    }

    public static String getVolumeString(long a) {
        StringBuilder builder = new StringBuilder();
        if (a >= FluidStack.bucketAmount()) {
            if (a % FluidStack.bucketAmount() != 0L) {
                builder.append(StringUtils.formatDouble((double)((double)a / (double)FluidStack.bucketAmount())));
            } else {
                builder.append(a / FluidStack.bucketAmount());
            }
            builder.append(" B");
        } else {
            builder.append(a).append(" mB");
        }
        return builder.toString();
    }

    public MutableComponent getAltTitle() {
        return new TextComponent(FluidTask.getVolumeString(this.amount) + " of ").m_7220_(this.createFluidStack().getName());
    }

    @Override
    public Icon getAltIcon() {
        FluidStack stack = this.createFluidStack();
        String id = Optional.ofNullable(FluidStackHooks.getStillTexture((FluidStack)stack)).map(TextureAtlasSprite::m_118413_).map(ResourceLocation::toString).orElse("missingno");
        return Icon.getIcon((String)id).withTint(Color4I.rgb((int)FluidStackHooks.getColor((FluidStack)stack)));
    }

    @Override
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.add("fluid", (ConfigValue)new FluidConfig(false), (Object)this.fluid, v -> {
            this.fluid = v;
        }, (Object)Fluids.f_76193_);
        config.add("fluid_nbt", (ConfigValue)new NBTConfig(), (Object)this.fluidNBT, v -> {
            this.fluidNBT = v;
        }, null);
        config.addLong("amount", this.amount, v -> {
            this.amount = v;
        }, FluidStack.bucketAmount(), 1L, Long.MAX_VALUE);
    }

    @Override
    public boolean canInsertItem() {
        return true;
    }

    @Override
    @Nullable
    public Object getIngredient() {
        return this.createFluidStack();
    }
}

